// 

//  lander.java version 1.0 (alpha) by Dan Creagan

//  this program requires some external .gif files .. get

//  them from the zip file available on the same page you

//  got this file from!

//



/*  lander.java uses the following HTML:

<HTML>

<body background = "stars.gif" bgcolor = "#000000" text = "#FFFFFF">

<img src = "globe.gif"><br><center><h1>Lander Simulation</h1>

<img src = "stars3.gif">

<center>

<APPLET 

Code=lander.class

Width=484 Height=320>

</APPLET><img src = "stars2.gif">

<img src = "surface.gif">

</HTML>

*/





import java.awt.*;

import java.util.*;

import java.applet.*;



public class lander extends Applet implements Runnable

{

  MediaTracker tracker;

 

  Thread kicker = null;

  Font tr18b = new Font("TimesRoman", Font.BOLD, 16);

  DialogOne Dia = new DialogOne("Warning!");

  DialogTwo Help = new DialogTwo("Help");

  Button engStart = new Button("EngStart");

  Button decThrust = new Button("EngDec.");

  Button incThrust = new Button("EngInc.");

  Button engStop = new Button("EngStop");

  Button fullThrust = new Button("EngFull");

  Button help = new Button("Help");

  Button sGame = new Button("StartSim");

  Label ThrustControl = new Label("Thrust Controllers For Lander",Label.CENTER);

  Label blank = new Label(" ");

  Image gauge;

  Image RAI;

  // construct gauge objects

  vGauge oThrust = new vGauge(171,18,23,50,34);

  vGauge oAltitude = new vGauge(171,18,84,50,34);

  vGauge oSpeed = new vGauge(171,18,144,50,34);

  vGauge oFuel = new vGauge(171,18,204,50,34);

 

  Panel p1 = new Panel();

  Panel p2 = new Panel();

  Panel p3 = new Panel();

  double currentAcceleration=0.0;

  double airspeed=0;

  double fuelLeft;

  double daltitude=0;

  double dhorizontal=0;

  double dvertical=0;

 

  //

  // drift variables are drift speed, accumulators will

  // accumulate drift if you are off the RAI screen. The

  // time to drift back to the target is proportional

  // to the amount of time/speed you were drifting while

  // target was off scope.

  //

  double dhdrift=0;

  double dvdrift=0;

  double accumulatedV=0;

  double accumulatedH=0;



  long runningTime=0;



  int MAXLEFT=275;

  int MAXRIGHT=440;

  int MAXUP=40;

  int MAXDOWN=210;

  int speed=0;

  int iThrust = 0;

  int iSpeed  = 0;

  int iAltitude = 100000;

  int iFuel   = 100000;

  int TargetThrust=0;

  int altitude=99;

  int r;



  boolean startGame=false;



  Random rand = new Random();



  Image osi;

  Graphics osg;



  public void init()

   {

     osi=createImage(482,360);

     osg=osi.getGraphics();



     setLayout(new BorderLayout());

     gauge = getImage(getCodeBase(),"guageImage.gif");

     RAI = getImage(getCodeBase(),"rai.gif");

     tracker = new MediaTracker(this);

     tracker.addImage(gauge,0);

          try

           {

             tracker.waitForAll();

           }

          catch(Exception e){System.out.println("No gauge.gif?");};

          tracker.addImage(RAI,0);

          try

           {

             tracker.waitForAll();

           }

          catch(Exception e){System.out.println("No rai.gif?");};

     p1.setLayout(new GridLayout(2,1)); // 2 rows and 1 col

     add("South",p1);

     p2.setLayout(new FlowLayout());

     p2.add(ThrustControl);

     p1.add(p2);

     p3.setLayout(new GridLayout(1,7));

     p3.add(sGame);

     p3.add(engStop);

     p3.add(engStart);

     p3.add(decThrust);

     p3.add(incThrust);

     p3.add(fullThrust);

     p3.add(help);

     p1.add(p3);

     fuelLeft=iFuel;

     daltitude = (double)iAltitude;

     oThrust.setCurrentAmount(iThrust);

     oSpeed.setCurrentAmount(iSpeed);

     oAltitude.setCurrentAmount(iAltitude);

     oFuel.setCurrentAmount(iFuel);

     accumulatedV=rand.nextInt() % 250;  // position cursors 126 and 360 are center

     accumulatedH=rand.nextInt() % 240 + 240;

     

  }

  

  public void calculateGauge(int snooze)

   {

      double gAcceleration; // acceleration by gravity

      double tAcceleration; // acceleration by thrust of engines

      double posTime; // time, in seconds, of this frame



      int weight=30000;  // basic weight of spaceship



      int fuelWeight = oFuel.getCurrentAmount() * 1000;// (100,000 pounds of fuel)





      int currentThrust=oThrust.getCurrentAmount() * 3000; //(300,000 pounds of thrust)

      

  

      if(fuelLeft < .001)

       {

        currentThrust=0;  

        oThrust.setCurrentAmount(0);

        iThrust=0;

       } 

     // calculate current time and acceleration



      posTime=(double)snooze/1000.0;

      

      gAcceleration = ((9.8/6)*Math.pow(posTime+1,2)); // moon gravity



      // acceleration due to thrusters will be proportional

      // to the acceleration due to gravity.  Therefore, if

      // we accelerate in the reverse direction at the same

      // thrust as the mass of the spacecraft, we will go nowhere

      

      tAcceleration = (weight + fuelWeight) - currentThrust;

      

      // tAcceleration equals the total thrust (positive or 

      // negative) of the craft. The ratio would be:

      // (gravity acceleration)/x{our unknown acceleration} = (weight+fuelWeight)/tAcceleration

      // therefore:

     

     tAcceleration = gAcceleration*tAcceleration/(weight+fuelWeight);

     currentAcceleration += tAcceleration;

     oSpeed.setCurrentAmount((int)(currentAcceleration/10.0));

     speed=oSpeed.getCurrentAmount();



     // calculate how far we dropped during this timeframe

   

     daltitude -= (currentAcceleration * ((double)snooze/1000.0));

     altitude = (int)daltitude/1000;

     iAltitude = (int)daltitude;

     oAltitude.setCurrentAmount(altitude);



     // compute fuel burn - max throttle is 1000 pps?

     if(fuelLeft>0)

     {

       double fuelBurn=(double)oThrust.getCurrentAmount()/100.0*((double)snooze/1000.0)*1000;

       fuelLeft-=fuelBurn;

       int fb=(int)((fuelLeft)/1000.0);

       oFuel.setCurrentAmount(fb);

     }

   }

  public void calculateRAI(int snooze)

   {

     runningTime+=snooze;

     if(runningTime>=100)  // update RAI every 100 ms

      {

        runningTime=0;

        accumulatedV+=dvdrift;

        accumulatedH+=dhdrift;

        dhorizontal=accumulatedV;

        dvertical = accumulatedH;



        if(dhorizontal>MAXDOWN) dhorizontal=MAXDOWN;

        if(dhorizontal<MAXUP) dhorizontal=MAXUP; 

        if(dvertical>MAXRIGHT) dvertical=MAXRIGHT; 

        if(dvertical<MAXLEFT) dvertical=MAXLEFT; 

    

      }

   }



  public void pause(int snooze)

   {

    calculateRAI(snooze);

    calculateGauge(snooze);

 

    if(oAltitude.getCurrentAmount()>10)

    {

    int r = rand.nextInt() % 100;



    // put some randomness into the whole thing (make the cursors move)

 

     if(r==50)

      {

        r = rand.nextInt() %2;

          if(r==0) dvdrift+=.2;

            else dvdrift-=.2;

      }

     if(r==49)

      {

        r = rand.nextInt() %2;

          if(r==0) dhdrift+=.2;

           else dvdrift-=.2;

      }

     // instability caused by engine burning

     if(oThrust.getCurrentAmount()>0)

      {

       if(dvdrift>0)

       dvdrift += (double)oThrust.getCurrentAmount()/100000;   

       if(dhdrift>0)

       dhdrift += (double)oThrust.getCurrentAmount()/100000;

       if(dvdrift<0)

       dvdrift -= (double)oThrust.getCurrentAmount()/100000;

       if(dhdrift<0)

       dhdrift -= (double)oThrust.getCurrentAmount()/100000;

      }

    }

    try {Thread.sleep(snooze);} catch (InterruptedException e){}

    

   }

/**

*  Double buffered output to stop my friend flicker

*

**/



  public void update(Graphics g)

   {

     osg.setColor(Color.white);// background for gauge

     osg.fillRect(0,0,242,360);

     osg.setColor(Color.blue.darker());// background for RAI

     osg.fillRect(245,10,235,240);

     osg.setColor(Color.red); // draw command bars

     osg.drawLine((int)dvertical+3,10,(int)dvertical+3,235); // draw vertical

     osg.drawLine((int)dvertical+2,10,(int)dvertical+2,235);

     osg.drawLine((int)dvertical+1,10,(int)dvertical+1,235);

     osg.drawLine((int)dvertical,10,(int)dvertical,235);

     osg.drawLine(250,(int)dhorizontal,460,(int)dhorizontal); // draw horizonal

     osg.drawLine(250,(int)dhorizontal+1,460,(int)dhorizontal+1);

     osg.drawLine(250,(int)dhorizontal+2,460,(int)dhorizontal+2);

     osg.drawLine(250,(int)dhorizontal+3,460,(int)dhorizontal+3);

     osg.drawImage(gauge,0,0,this);

     osg.drawImage(gauge,61,0,this);

     osg.drawImage(gauge,121,0,this);

     osg.drawImage(gauge,181,0,this);

     // fill in gauge information

     osg.setColor(Color.red);

     osg.drawString("Thrust",12,25);

     osg.drawString("Altitude",72,25);

     osg.drawString("V-Speed",129,25);

     osg.drawString("Fuel",200,25);

     osg.drawString(Integer.toString(iThrust),20,235);

     osg.drawString("%",40,235);

     osg.drawString(Integer.toString(iAltitude),70,235);

     osg.drawString("m",108,235);

     osg.drawString(Integer.toString((int)(currentAcceleration*-1)),130,235);

     osg.drawString("ms",160,235);

     osg.drawString(Integer.toString((int)(fuelLeft)),190,235);

     osg.setColor(Color.red);

     // fill in RAI information

     osg.drawString("Y: " + Double.toString(dvdrift),320,55);

     osg.drawString("X: " + Double.toString(dhdrift),290,145);

     // make landing pad grow as you get closer

     int x = (int)(dvertical-.5*(40.0*(1.0/(altitude + 1))));

     int y = (int)(dhorizontal - .5 *(40.0*(1.0/(altitude + 1))));

     int h = (int)(40.0 *(1.0/(altitude+1)));



     osg.setColor(Color.green.darker());

     osg.fillOval(x,y,h,h);

     osg.setColor(Color.white);

     osg.drawOval(Math.abs(x+2),Math.abs(y+2),Math.abs(h-5),Math.abs(h-5));

     if(iAltitude < 1000) 

       {

        osg.setColor(Color.red);

        osg.drawString("Pad",(int)dvertical-12,(int)dhorizontal+5);

       } 

     osg.setColor(Color.red);

     // paint gauge data

     oThrust.paint(osg);

     if(oAltitude.getCurrentAmount()>20) osg.setColor(Color.green);

        else osg.setColor(Color.red);

     oAltitude.paint(osg);

     if((oSpeed.getCurrentAmount()>75)&&(oAltitude.getCurrentAmount()<20)) osg.setColor(Color.red);

        else osg.setColor(Color.green);

     oSpeed.paint(osg);

     if(oFuel.getCurrentAmount()>10) osg.setColor(Color.green);

        else osg.setColor(Color.red);

     oFuel.paint(osg);

     osg.drawImage(RAI,241,0,this);



     g.drawImage(osi,0,0,this);

    }

  public void paint(Graphics g)

    {

       update(g);

    }

  public void run()  // create thread, set up guages, check for success

        {



        //  Create the thread

        Thread.currentThread().setPriority(Thread.MAX_PRIORITY);

        altitude=oAltitude.getCurrentAmount();

        speed=oSpeed.getCurrentAmount();



        //  Do the animation

        while (kicker != null) {



            if(startGame)  // player has clicked on StartSim

             {

              if(daltitude<5000.0)

               {

                 ThrustControl.setFont(tr18b);

                 ThrustControl.setText("Alt: " + Integer.toString((int)daltitude) + "  MPS: " + Integer.toString((int)(currentAcceleration *-1)));                

               }



            if((daltitude*1000.0)<.001){ // you touched down - hopefully softly

               

    // check for meatball in right place

              int x = (int)(dvertical-.5*(40.0*(1.0/(altitude + 1))));

              int y = (int)(dhorizontal - .5 *(40.0*(1.0/(altitude + 1))));

 

              if((x < 320) || (x>360))

                {

                  ThrustControl.setText("Missed pad");

                  stop();

                  return;

                }

              if((y < 83) || (y>123))

                {

                  ThrustControl.setText("Missed pad");

                  stop();

                  return;

                }

              if(currentAcceleration <2.0)

                 {

                   ThrustControl.setText("Good Landing!");

                   stop();

                   return;

                 }

               if(currentAcceleration < 5)

                 {

                   ThrustControl.setText("Damage! (oh, oh!)");

                   stop();

                   return;

                  }

                 ThrustControl.setText("Yer DEAD!");

                 stop();

                 return;

              }  

            oSpeed.setCurrentAmount(speed);

            oAltitude.setCurrentAmount(altitude);

            int currentThrust=oThrust.getCurrentAmount();

          //

          // throttle adjustments are not instantaneous 

          // it takes a second or two to get to full thrust

          //

            while(TargetThrust != currentThrust)

              {

                 if(TargetThrust < currentThrust)

                    currentThrust--;

                 else currentThrust++;

                 oThrust.setCurrentAmount(currentThrust);

                 repaint();

                 pause(10);

              }



            altitude = oAltitude.getCurrentAmount();

            speed = oSpeed.getCurrentAmount();

            if ((altitude>20)&&(altitude<100))

              {

                 oAltitude.setCurrentAmount(altitude+r);

              }

            

            //

            // put some randomness into high descent rates

            // 



            r=rand.nextInt() % 2;

            if ((speed>30) && (speed<100))

              {

                 oSpeed.setCurrentAmount(speed+r);

              }

            repaint();

          

            pause(100);

        }

        else  // sim isn't started so none of the above triggers,

              // just sleep until player starts simulation

           try {Thread.sleep(20);} catch (InterruptedException e){}

       }

    }



 public boolean keyDown(Event evt, int key) { // trap keyboard strokes



   // if below 1000, then make arrow keys less sensitive



   if(iAltitude<1000)

    {

    switch (key) {

    case Event.UP: 

        dvdrift+=.05;

        break;

    case Event.DOWN: 

        dvdrift-=.05;

        break;

    case Event.RIGHT:

        dhdrift-=.05;

      break;

    case Event.LEFT:

        dhdrift+=.05;

      break;

    case (char)'s':

          TargetThrust=30;

          iThrust=30;

          repaint();

          break;

     case (char)'d':

          if(oThrust.getCurrentAmount()==0)

           {

             Dia.show();

             return true;

           }

          iThrust -=1;

          if(iThrust < 0) iThrust = 0;

          TargetThrust=iThrust;

          repaint();

          break;

     case (char)'f':

          if(oThrust.getCurrentAmount()==0)

           {

             Dia.show();

             return true;

           }

          iThrust +=1;

          if(iThrust > 100) iThrust = 100;

          TargetThrust=iThrust;

          repaint();

          break;

     }

    }

   else

    {

    switch (key) {

    case Event.UP: 

        dvdrift+=.1;

        break;

    case Event.DOWN: 

        dvdrift-=.1;

        break;

    case Event.RIGHT:

        dhdrift-=.1;

      break;

    case Event.LEFT:

        dhdrift+=.1;

      break;

    case (char)'s':

          TargetThrust=30;

          iThrust=30;

          repaint();

          break;

    case (char)'d':

          if(oThrust.getCurrentAmount()==0)

           {

             Dia.show();

             return true;

           }

          iThrust -=1;

          if(iThrust < 0) iThrust = 0;

          TargetThrust=iThrust;

          repaint();

          break;

     case (char)'f':

          if(oThrust.getCurrentAmount()==0)

           {

             Dia.show();

             return true;

           }

          iThrust +=1;

          if(iThrust > 100) iThrust = 100;

          TargetThrust=iThrust;

          repaint();

          break;

     }

    }

    repaint();

    return true;

  }



  public boolean action(Event evt, Object arg) // trap button clicks

     {

      int x=0;

      if(arg == "Help")

       {

         Help.resize(420,440);

         Help.show();

         return true;

       }

      if(arg == "StartSim")

        {

          startGame=true;

          return true;

        }

      if(fuelLeft<.001)

        {

         TargetThrust=0;

         iThrust=0;

         return true;

        }

      if(arg == "EngStop")

        {

          TargetThrust=0;

          iThrust=0;

          repaint();

        }

      if(arg == "EngStart")

        {

          

          TargetThrust=30;

          iThrust=30;

          repaint();

          

        }        

      if(arg == "EngDec.")

        {

          if(oThrust.getCurrentAmount()==0)

           {

             Dia.show();

             return true;

           }

          iThrust -=1;

          if(iThrust < 0) iThrust = 0;

          TargetThrust=iThrust;

          repaint();

        }

      if(arg == "EngInc.")

        {

          

          if(oThrust.getCurrentAmount()==0)

           {

             Dia.show();

             return true;

           }

          iThrust +=1;

          if(iThrust > 100) iThrust = 100;

          TargetThrust=iThrust;

          repaint();

        }

      if(arg == "EngFull")

        {

          if(fuelLeft<.001) return true;

          if(oThrust.getCurrentAmount()==0)

           {

             Dia.show();

             return true;

           }

          TargetThrust = 100;

          iThrust = 100;

          repaint();

        }

      Dia.hide();

      return false;

    }

  

  //  

    //  start

    //  

    //  Requires:  nothing

    //  Modifies:  nothing

    //  Effects:   Start the applet by forking an animation thread

    //



    public void start() 

        {

        if (kicker == null) {

            kicker = new Thread(this);

            kicker.start();

            }

        }

   //  

    //  stop

    //  

    //  Requires:  nothing

    //  Modifies:  nothing

    //  Effects:   Stop the applet. The thread will exit because kicker 

    //             is set to null.

    //



    public void stop() 

        {

        kicker = null;

        }



}



class DialogOne extends Frame

{



  Label ta = new Label("You Must Start Engines! ");



  DialogOne(String title) // warning dialog, you must start

                          // engines before you adjust thrust

    {

      super(title);

      setLayout(new FlowLayout());

      add(ta);

      this.resize(200,100);

      this.pack();

    }

 

    public boolean handleEvent (Event e)

	{

                if (e.id == Event.WINDOW_DESTROY && e.target == this) 

                  this.hide();

                

		return super.handleEvent (e);

	}

}



class DialogTwo extends Frame // help dialog

{



  List ta = new List(26,false);



  DialogTwo(String title)

    {

      super(title);

      setLayout(new BorderLayout());

      ta.addItem( "                                     Welcome To Lander");

      ta.addItem(" ");

      ta.addItem(" ");

      ta.addItem("    Capsule weight:                       30,000 lbs");

      ta.addItem("    Fuel weight:                            100,000 lbs");

      ta.addItem("    Thrust:                                   300,000 lbs");

      ta.addItem("    Height Above Moon:                100,000 meters");

      ta.addItem("    Fuel Consumption/Max Thrust:  1000 lbs/sec");

      ta.addItem("    notes:"); 

      ta.addItem("            a. Fuel burns, weight decreases, thrust must be adjusted");

      ta.addItem("            b. Arrow keys control movement over surface");

      ta.addItem("            c. You must have landing pad on cross hairs of");

      ta.addItem("                the Remote Attitude Indicator (RAI) or you crash");

      ta.addItem("            d. Landing descent rate must be < 3");

      ta.addItem("            e. Use mouse to increase, decrease or stop burns");

      ta.addItem("            f. Gravity acceleration is 1/6 that of Earth");

      ta.addItem("            g. Lateral acceleration is cumulative");

      ta.addItem("            h. Left arrow moves you towards left command bar, etc");

      ta.addItem("            i. Engine turbulance causes some horizontal drift");

      ta.addItem("            j. Horizontal controls aren't as sensitive below 1000 AGL");

      ta.addItem("            k. Altitude and drift are a little erratic above 1000 AGL");

      ta.addItem("            l. Per popular request: the s,d,k keys are thrust start, ");

      ta.addItem("               decrease, and increase. You don't need the mouse to land.");

      ta.addItem("            m. If the engine is stopped, you must start it before");

      ta.addItem("               you adjust thrust.");

      ta.addItem(" ");

      ta.addItem("    Good Luck!");

      ta.addItem("    Dan Creagan");

      add("Center",ta);

      ta.disable();

      this.pack();

    }

 

    public boolean handleEvent (Event e)

	{

                if (e.id == Event.WINDOW_DESTROY && e.target == this) 

                  this.hide();

                

		return super.handleEvent (e);

	}

}









/**

 * Make a gauge class whose tape rises vertically instead

 * of sideways or down (like all the examples .. yuch!)

 *

 **/

  



class vGauge {

  // Gauge variables



  int height;   

  int width ; 

  int xpos  ;

  int ypos  ;

  int maxDeflection ; 

  int base ;

  int ystart ;

  int currentAmount;



    

  public vGauge()

   {

  // The default size of the gauge (a small one for web pages)



   height = 25;   

   width  = 8;  // default and very arbitrary values 

   xpos   = 19;

   ypos   = 41;

   maxDeflection = 20; // arbitrary top of bar deflection

   base = 66;

   ystart = 41;

   currentAmount=25; // who knows

  }

  /**

  * constructs a Gauge that changes all default values

  *

  ******/



  public vGauge(int h, int w, int xp, int yp, int md)

   {

     height =h;

     width  =w;

     xpos   =xp;

     ypos   =yp;

     maxDeflection =md;

     base   =height+ypos;

     ystart =ypos;

   }



  public void paint(Graphics g) {



    //

    // here's the key line ... to get the bar to appear to

    // grow upwards, make the starting position move and

    // always change the ending position so it is in the same

    // place .. or something like that

    //

      g.fill3DRect(xpos,ypos,width,base-ypos,true);  

}



  public void setCurrentAmount(int Amount) {



    // we need to change Amount to a percentage of the actual

    // distance we are covering.  So 0 gets zero on the bar

    // and 100 gets max.



      currentAmount = Amount;

      Amount = (int)(Amount * ((float)(((float)base - (float)maxDeflection)/100.00)));

      ypos = base - Amount; // cause bar to grow upwards

      

    // make sure we don't go less than max deflection

      if(ypos < maxDeflection)

        ypos=maxDeflection;

    // and make sure we don't go greater than the base

      if(ypos > base)

        ypos=base;

  }

  int getCurrentAmount()

   {

     return currentAmount;

   }

}



